/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.scripting.Messages;
import com.aptana.scripting.internal.model.BundleMonitor;
import com.aptana.scripting.listeners.FileWatcherRegistrant;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.RunType;
import net.contentobjects.jnotify.JNotifyException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.BundleContext;

public class ScriptingActivator
extends Plugin {
    public static final String PLUGIN_ID = "com.aptana.scripting";
    private static ScriptingActivator plugin;
    public static final String EDITOR_CONTEXT_ID = "com.aptana.editor.context";
    private BundleManager bundleManager;
    private BundleMonitor bundleMonitor;

    public static ScriptingActivator getDefault() {
        return plugin;
    }

    public static RunType getDefaultRunType() {
        return RunType.CURRENT_THREAD;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        Job startupJob = new Job("Start Ruble bundle manager"){

            protected IStatus run(IProgressMonitor monitor) {
                BundleManager manager = ScriptingActivator.this.getBundleManager();
                FileWatcherRegistrant.getInstance();
                if (EclipseUtil.isTesting()) {
                    System.out.println("Not auto-loading bundles since we are running unit tests");
                } else {
                    manager.loadBundles();
                }
                try {
                    ScriptingActivator.this.getBundleMonitor().beginMonitoring();
                }
                catch (JNotifyException e) {
                    IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)Messages.EarlyStartup_Error_Initializing_File_Monitoring, (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        startupJob.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            try {
                this.bundleManager = null;
                if (this.bundleMonitor != null) {
                    this.bundleMonitor.endMonitoring();
                    this.bundleMonitor = null;
                }
                FileWatcherRegistrant.shutdown();
            }
            catch (Exception exception) {
                plugin = null;
                super.stop(context);
            }
        }
        finally {
            plugin = null;
            super.stop(context);
        }
    }

    private synchronized BundleMonitor getBundleMonitor() {
        if (this.bundleMonitor == null) {
            this.bundleMonitor = new BundleMonitor(this.getBundleManager());
        }
        return this.bundleMonitor;
    }

    public synchronized BundleManager getBundleManager() {
        if (this.bundleManager == null) {
            this.bundleManager = BundleManager.getInstance();
        }
        return this.bundleManager;
    }
}

